--- @meta

-- This file is autogenerated. Do not edit this file manually. Your changes will be ignored.
-- More information: https://github.com/MWSE/MWSE/tree/master/docs

--- An object that allows the sharing of vertices between triangles to create shapes.
--- @class niTriShape : niTriBasedGeometry, niGeometry, niAVObject, niObjectNET, niObject
--- @field data niTriShapeData The NiTriShapeData of the object. Manipulation should not be done directly. Instead, consider copying the data and assigning it to this shape.
--- @field normals tes3vector3[] *Read-only*. The list of unitized, model-space vertex normals for the object. The length of the array is equal to the vertex count.
--- @field skinInstance niSkinInstance The skinInstance of the object.
--- @field vertices tes3vector3[] *Read-only*. The array of vertex position data. The length of the array is equal to vertex count.
niTriShape = {}

--- Creates a new niTriShape.
--- @param vertexCount number The number of vertices the shape will allocate.
--- @param hasNormals boolean If `true`, normals will be allocated.
--- @param hasColors boolean If `true`, colors will be allocated.
--- @param textureCoordSets number The number of texture coordinate sets (UV sets) to allocate.
--- @param triangleCount number The number of triangles to allocate.
--- @return niTriShape shape No description yet available.
function niTriShape.new(vertexCount, hasNormals, hasColors, textureCoordSets, triangleCount) end

--- Calculates and creates a bounding box for the object. The existing bounding box, if any, will not be used, a fresh one will always be calculated.
--- @param args? niTriShape.createBoundingBox.args This table accepts the following values:
--- 
--- `accurateSkinned?`: boolean — *Default*: `false`. If true, [`niSkinInstance`](http://mwse.github.io/MWSE/types/niSkinInstance/?h=niskininstan) deformations will be applied before calculating the bounding box. This has an additional performance cost
--- 
--- `observeAppCullFlag?`: boolean — *Default*: `false`. If true, objects that have the [`appCulled`](http://mwse.github.io/MWSE/types/niAVObject/#appculled) flag set will be ignored.
--- 
--- `onlyActiveChildren?`: boolean — *Default*: `false`. If true, only the [`active children`](https://mwse.github.io/MWSE/types/niSwitchNode/#getactivechild) will be processed.
--- @return tes3boundingBox boundingBox The newly created bounding box.
function niTriShape:createBoundingBox(args) end

---Table parameter definitions for `niTriShape.createBoundingBox`.
--- @class niTriShape.createBoundingBox.args
--- @field accurateSkinned? boolean *Default*: `false`. If true, [`niSkinInstance`](http://mwse.github.io/MWSE/types/niSkinInstance/?h=niskininstan) deformations will be applied before calculating the bounding box. This has an additional performance cost
--- @field observeAppCullFlag? boolean *Default*: `false`. If true, objects that have the [`appCulled`](http://mwse.github.io/MWSE/types/niAVObject/#appculled) flag set will be ignored.
--- @field onlyActiveChildren? boolean *Default*: `false`. If true, only the [`active children`](https://mwse.github.io/MWSE/types/niSwitchNode/#getactivechild) will be processed.

